users = {}
with open("/etc/passwd") as passwd_file:
    for line in passwd_file:
        import string
        fields = string.split(line, ":")
        try:
            users[fields[0]] = {"uid":fields[2], 
                                "gid":fields[3], 
                                "home":fields[5], 
                                "shell":fields[6]}
        # using exception to skip lines that did not parse
        except IndexError as err:
            continue

try:
    print "Uzytkownik root ma uid:", users["root"]["uid"], "i gid:", users["root"]["gid"]
    print users["kberezow"]["uid"]
except KeyError as err:
    print "Uzytkownik", err.message, "nie istnieje w systemie"
except Exception:
    print "Nieznany blad"
except:
    print "Nieznana sytuacja wyjatkowa"
else:
    print "Program nie wygenerowal zadnych sytuacji wyjatkowych"
    